/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.util.GregorianCalendar;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class AnalogClock
extends JPanel
implements Runnable,
MouseListener {
    private static final double TENTH_HAND_LENGTH = 0.9;
    private static final double SECOND_HAND_LENGTH = 0.9;
    private static final double MINUTE_HAND_LENGTH = 0.7;
    private static final double HOUR_HAND_LENGTH = 0.4;
    private static final double TENTH_HAND_WIDTH = 0.03;
    private static final double SECOND_HAND_WIDTH = 0.04;
    private static final double MINUTE_HAND_WIDTH = 0.06;
    private static final double HOUR_HAND_WIDTH = 0.08;
    private Color dialColor = Color.WHITE;
    private static final Color EDGE_COLOR = Color.GRAY;
    private boolean displayTime = true;
    private boolean displayDate = true;
    private boolean fancyHands = true;
    private boolean tenthSecondHand = true;
    private int updateRate = 10;

    public AnalogClock() {
        this.setBackground(Color.BLACK);
        this.addMouseListener(this);
        Thread thread = new Thread(this);
        thread.start();
    }

    @Override
    public void paint(Graphics graphics) {
        double d;
        double d2;
        double d3;
        double d4;
        super.paint(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        Dimension dimension = this.getSize();
        Point point = new Point(dimension.width / 2, dimension.height / 2);
        int n = (int)((double)Math.min(point.x, point.y) * 0.9);
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        graphics2D.setColor(this.dialColor);
        graphics2D.setStroke(new BasicStroke(Math.max(2, n / 50)));
        Font font = new Font("MonoSpaced", 0, n / 4);
        graphics2D.setFont(font);
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        TextLayout textLayout = new TextLayout("0", font, fontRenderContext);
        Rectangle2D rectangle2D = textLayout.getBounds();
        int n2 = (int)rectangle2D.getHeight();
        graphics2D.drawOval(point.x - n, point.y - n, n * 2, n * 2);
        for (d4 = 0.0; d4 < Math.PI * 2; d4 += 0.5235987755982988) {
            graphics2D.drawLine(point.x + (int)(Math.cos(d4) * (double)n * 0.8), point.y + (int)(Math.sin(d4) * (double)n * 0.8), point.x + (int)(Math.cos(d4) * (double)n * 0.9), point.y + (int)(Math.sin(d4) * (double)n * 0.9));
        }
        graphics2D.drawString("3", point.x + (int)(Math.cos(0.0) * (double)n * 0.7) - fontMetrics.charWidth('0') / 2, point.y + (int)(Math.sin(0.0) * (double)n * 0.6) + n2 / 2);
        graphics2D.drawString("6", point.x + (int)(Math.cos(1.5707963267948966) * (double)n * 0.7) - fontMetrics.charWidth('0') / 2, point.y + (int)(Math.sin(1.5707963267948966) * (double)n * 0.6) + n2 / 2);
        graphics2D.drawString("9", point.x + (int)(Math.cos(Math.PI) * (double)n * 0.7) - fontMetrics.charWidth('0') / 2, point.y + (int)(Math.sin(Math.PI) * (double)n * 0.6) + n2 / 2);
        graphics2D.drawString("12", point.x + (int)(Math.cos(4.71238898038469) * (double)n * 0.7) - fontMetrics.charWidth('0'), point.y + (int)(Math.sin(4.71238898038469) * (double)n * 0.6) + n2 / 2);
        if (this.displayTime) {
            graphics2D.drawString(String.format("%tT", gregorianCalendar), point.x - fontMetrics.stringWidth("00:00:00") / 2, point.y + n / 3);
        }
        d4 = (double)gregorianCalendar.get(10) * 60.0 + (double)gregorianCalendar.get(12);
        double d5 = Math.PI * 2 / (720.0 / d4);
        d5 -= 1.5707963267948966;
        if (this.fancyHands) {
            d3 = (double)n * 0.08;
            d2 = (double)n * 0.2;
            d = (double)n * 0.4;
            Polygon polygon = new Polygon();
            polygon.addPoint(point.x - (int)(Math.cos(d5 + 1.5707963267948966) * d3), point.y - (int)(Math.sin(d5 + 1.5707963267948966) * d3));
            polygon.addPoint(point.x + (int)(Math.cos(d5) * d), point.y + (int)(Math.sin(d5) * d));
            polygon.addPoint(point.x - (int)(Math.cos(d5 - 1.5707963267948966) * d3), point.y - (int)(Math.sin(d5 - 1.5707963267948966) * d3));
            polygon.addPoint(point.x + (int)(Math.cos(d5 + Math.PI) * d2), point.y + (int)(Math.sin(d5 + Math.PI) * d2));
            graphics2D.setColor(this.dialColor);
            graphics2D.fill(polygon);
            graphics2D.setColor(EDGE_COLOR);
            graphics2D.setStroke(new BasicStroke(1.0f));
            graphics2D.draw(polygon);
        } else {
            graphics2D.drawLine(point.x - (int)(Math.cos(d5) * (double)n * 0.1), point.y - (int)(Math.sin(d5) * (double)n * 0.1), point.x + (int)(Math.cos(d5) * (double)n * 0.4), point.y + (int)(Math.sin(d5) * (double)n * 0.4));
        }
        d3 = (double)gregorianCalendar.get(12) * 60.0 + (double)gregorianCalendar.get(13);
        d5 = Math.PI * 2 / (3600.0 / d3);
        d5 -= 1.5707963267948966;
        if (this.fancyHands) {
            d2 = (double)n * 0.06;
            d = (double)n * 0.2;
            double d6 = (double)n * 0.7;
            Polygon polygon = new Polygon();
            polygon.addPoint(point.x - (int)(Math.cos(d5 + 1.5707963267948966) * d2), point.y - (int)(Math.sin(d5 + 1.5707963267948966) * d2));
            polygon.addPoint(point.x + (int)(Math.cos(d5) * d6), point.y + (int)(Math.sin(d5) * d6));
            polygon.addPoint(point.x - (int)(Math.cos(d5 - 1.5707963267948966) * d2), point.y - (int)(Math.sin(d5 - 1.5707963267948966) * d2));
            polygon.addPoint(point.x + (int)(Math.cos(d5 + Math.PI) * d), point.y + (int)(Math.sin(d5 + Math.PI) * d));
            graphics2D.setColor(this.dialColor);
            graphics2D.fill(polygon);
            graphics2D.setColor(EDGE_COLOR);
            graphics2D.draw(polygon);
        } else {
            graphics2D.drawLine(point.x - (int)(Math.cos(d5) * (double)n * 0.1), point.y - (int)(Math.sin(d5) * (double)n * 0.1), point.x + (int)(Math.cos(d5) * (double)n * 0.7), point.y + (int)(Math.sin(d5) * (double)n * 0.7));
        }
        d2 = (double)gregorianCalendar.get(13) * 1000.0 + (double)gregorianCalendar.get(14);
        d5 = Math.PI * 2 / (60000.0 / d2);
        d5 -= 1.5707963267948966;
        if (this.fancyHands) {
            d = (double)n * 0.04;
            double d7 = (double)n * 0.3;
            double d8 = (double)n * 0.9;
            Polygon polygon = new Polygon();
            polygon.addPoint(point.x - (int)(Math.cos(d5 + 1.5707963267948966) * d), point.y - (int)(Math.sin(d5 + 1.5707963267948966) * d));
            polygon.addPoint(point.x + (int)(Math.cos(d5) * d8), point.y + (int)(Math.sin(d5) * d8));
            polygon.addPoint(point.x - (int)(Math.cos(d5 - 1.5707963267948966) * d), point.y - (int)(Math.sin(d5 - 1.5707963267948966) * d));
            polygon.addPoint(point.x + (int)(Math.cos(d5 + Math.PI) * d7), point.y + (int)(Math.sin(d5 + Math.PI) * d7));
            graphics2D.setColor(this.dialColor);
            graphics2D.fill(polygon);
            graphics2D.setColor(EDGE_COLOR);
            graphics2D.draw(polygon);
        } else {
            graphics2D.drawLine(point.x - (int)(Math.cos(d5) * (double)n * 0.2), point.y - (int)(Math.sin(d5) * (double)n * 0.2), point.x + (int)(Math.cos(d5) * (double)n * 0.9), point.y + (int)(Math.sin(d5) * (double)n * 0.9));
        }
        if (this.tenthSecondHand) {
            d = d2 % 1000.0;
            d5 = Math.PI * 2 / (1000.0 / d);
            d5 -= 1.5707963267948966;
            if (this.fancyHands) {
                double d9 = (double)n * 0.03;
                double d10 = (double)n * 0.3;
                double d11 = (double)n * 0.9;
                Polygon polygon = new Polygon();
                polygon.addPoint(point.x - (int)(Math.cos(d5 + 1.5707963267948966) * d9), point.y - (int)(Math.sin(d5 + 1.5707963267948966) * d9));
                polygon.addPoint(point.x + (int)(Math.cos(d5) * d11), point.y + (int)(Math.sin(d5) * d11));
                polygon.addPoint(point.x - (int)(Math.cos(d5 - 1.5707963267948966) * d9), point.y - (int)(Math.sin(d5 - 1.5707963267948966) * d9));
                polygon.addPoint(point.x + (int)(Math.cos(d5 + Math.PI) * d10), point.y + (int)(Math.sin(d5 + Math.PI) * d10));
                graphics2D.setColor(this.dialColor);
                graphics2D.fill(polygon);
                graphics2D.setColor(EDGE_COLOR);
                graphics2D.draw(polygon);
            } else {
                graphics2D.drawLine(point.x - (int)(Math.cos(d5) * (double)n * 0.2), point.y - (int)(Math.sin(d5) * (double)n * 0.2), point.x + (int)(Math.cos(d5) * (double)n * 0.9), point.y + (int)(Math.sin(d5) * (double)n * 0.9));
            }
        }
        if (this.fancyHands) {
            int n3 = (int)((double)n * 0.02);
            graphics2D.setColor(Color.BLACK);
            graphics2D.fillOval(point.x - n3, point.y - n3, n3 * 2, n3 * 2);
        }
        if (this.displayDate) {
            graphics2D.setColor(this.dialColor);
            graphics2D.drawString(String.format("%ta", gregorianCalendar), 1, fontMetrics.getAscent());
            graphics2D.drawString(String.format("%te", gregorianCalendar), 1, fontMetrics.getAscent() * 2);
        }
    }

    @Override
    public void run() {
        while (true) {
            try {
                Thread.sleep(this.updateRate);
            }
            catch (Exception exception) {
                System.out.println(exception);
            }
            this.repaint();
        }
    }

    public void setDialColor(Color color) {
        this.dialColor = color;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == 3) {
            this.setup();
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    private void setup() {
        final JDialog jDialog = new JDialog();
        jDialog.setDefaultCloseOperation(2);
        jDialog.setTitle("Setup");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        final JCheckBox jCheckBox = new JCheckBox("Fancy Hands", this.fancyHands);
        final JCheckBox jCheckBox2 = new JCheckBox("Tenth Second hand", this.tenthSecondHand);
        final JCheckBox jCheckBox3 = new JCheckBox("Display Date", this.displayDate);
        final JCheckBox jCheckBox4 = new JCheckBox("Display Time", this.displayTime);
        jPanel.add(jCheckBox);
        jPanel.add(jCheckBox2);
        jPanel.add(jCheckBox3);
        jPanel.add(jCheckBox4);
        JButton jButton = new JButton("Cancel");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.setVisible(false);
            }
        });
        JButton jButton2 = new JButton("OK");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AnalogClock.this.fancyHands = jCheckBox.isSelected();
                AnalogClock.this.tenthSecondHand = jCheckBox2.isSelected();
                AnalogClock.this.updateRate = AnalogClock.this.tenthSecondHand ? 10 : 100;
                AnalogClock.this.displayDate = jCheckBox3.isSelected();
                AnalogClock.this.displayTime = jCheckBox4.isSelected();
                jDialog.setVisible(false);
            }
        });
        JPanel jPanel2 = new JPanel(new GridLayout(1, 2));
        jPanel2.add(jButton2);
        jPanel2.add(jButton);
        jPanel.add(jPanel2);
        jDialog.add(jPanel);
        jDialog.pack();
        jDialog.setLocationRelativeTo(this);
        jDialog.setVisible(true);
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("Clock");
        jFrame.setDefaultCloseOperation(3);
        AnalogClock analogClock = new AnalogClock();
        jFrame.setContentPane(analogClock);
        jFrame.setSize(200, 200);
        jFrame.setVisible(true);
    }
}

